/** @file   corpse.cpp
 * @brief   Implementation of Corpse - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */
 
#include "corpse.h"
#include "GfxManager.h"
#include "www_map.h"
#include "redrawqueue.h"
#include "gfxid.h"
using namespace eng2d;

namespace WeWantWar {

/** Constructor
 */
Corpse::Corpse( ID corpseID ) :
  GameObject( )
{
  this->setProperties( GameObject::PROP_GRENADEFORCE );
  
  this->state( GameObject::STATE_KILLED );
  
  GraphicsContainer* combine = GfxManager::findGfxContainer( GfxId::KCorpses );
  int numOfCorpses = combine->GraphicCount();
  m_corpseGfxID = rand() % numOfCorpses;
}



/** Constructor.
 */
Corpse::Corpse() :
  GameObject( )
{
  this->state( GameObject::STATE_KILLED );
  GraphicsContainer* combine = GfxManager::findGfxContainer( GfxId::KCorpses );
  int numOfCorpses = combine->GraphicCount();
  m_corpseGfxID = rand() % numOfCorpses;
  
  // Set the collisionpoints
  this->setCollisionPoint( 0, Vec2D(-12,-12) );
  this->setCollisionPoint( 1, Vec2D( 12,-12) );
  this->setCollisionPoint( 2, Vec2D( 12, 12) );
  this->setCollisionPoint( 3, Vec2D(-12, 12) );
}



/** Destructor.
 */
Corpse::~Corpse()
{
}




/** The update-method
 */
void Corpse::update()
{
}



/** Draws this corpse to given bitmap.
 */
void Corpse::redraw( RedrawQueue* pQueue )
{
  Vec2D p( this->position() );
  int alX = static_cast<int>( p.x() ) - Map::scrollX;
  int alY = static_cast<int>( p.y() ) - Map::scrollY;

  GraphicsContainer* combine = GfxManager::findGfxContainer( GfxId::KCorpses );
  RLE_SPRITE* corpseGraphic = combine->GetRleSprite( this->getGfxID() );
  alX -= corpseGraphic->w / 2;
  alY -= corpseGraphic->h / 2;

  pQueue->add( RedrawQueue::PRI_KILLED, alX, alY,
               RedrawQueue::SPTYPE_RLE, corpseGraphic );
}



/** Makes sound.
 */
void Corpse::makeSound( GameObject::SoundID id ) const
{
}



/** We got hit by a bullet
 */
bool Corpse::hitByBullet( Bullet* pB )
{
  return false;
}



/** Kills this object.
 */
void Corpse::kill()
{
}



/** Reloading
 */
bool Corpse::reloading() const
{
  return false;
}



/** Returns the type of this object.
 */
ObjectID::Type Corpse::objectType() const
{
  return ObjectID::TYPE_CORPSE;
}



/** Tells witch corpse images represents this corpse.
 */
int Corpse::getGfxID() const
{
  return m_corpseGfxID;
}

} // end of namespace
